/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import flash.io.BitInput;
import flash.io.BitLibrary;
import flash.io.BitOutput;
import flash.io.TypeReader;
import flash.io.TypeWriter;
import flash.objects.FMovie;
import flash.objects.FRect;
import flash.tags.TBlock;
import flash.tags.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;

public class BlockIO {
    private BitInput bi;
    private BitOutput bo;
    private BitLibrary bl;
    private TypeReader myTypeReader;
    private TypeWriter myTypeWriter;

    public Object[] readFlash(File file) throws Exception {
        int n;
        try {
            this.bi = new BitInput(new FileInputStream(file));
            this.bl = new BitLibrary(this.bi);
        }
        catch (Exception exception) {
            return null;
        }
        String string = (char)this.bl.ui8() + "" + (char)this.bl.ui8() + (char)this.bl.ui8();
        FMovie fMovie = null;
        long l = 0L;
        if (string.equals("CWS")) {
            n = (int)this.bl.ui8();
            l = this.bl.ui32();
            this.bi.useCompressedStream();
            this.myTypeReader = new TypeReader(this.bl, this.bi, n);
            FRect fRect = this.myTypeReader.rect();
            float f = (float)this.bl.ui16() / 256.0f;
            long l2 = this.bl.ui16();
            fMovie = new FMovie(string, n, l, fRect, f, l2);
        } else {
            n = (int)this.bl.ui8();
            l = this.bl.ui32();
            this.myTypeReader = new TypeReader(this.bl, this.bi, n);
            fMovie = new FMovie(string, n, l, this.myTypeReader.rect(), (float)this.bl.ui16() / 256.0f, this.bl.ui16());
        }
        Object[] objectArray = new Object[]{fMovie, this.readBlocks(l)};
        this.bi.close();
        this.bi = null;
        this.bl = null;
        return objectArray;
    }

    public Vector readBlocks(long l) throws Exception {
        Tag tag = null;
        TBlock tBlock = null;
        Vector<TBlock> vector = new Vector<TBlock>();
        long l2 = 0L;
        long l3 = 0L;
        while (this.bi.bitsRead < l) {
            tag = this.myTypeReader.tag();
            l2 = this.bi.bitsRead;
            l3 = l2 + tag.length;
            tBlock = new TBlock(tag.id, tag.length);
            byte[] byArray = this.bi.readBytes2((int)tag.length);
            tBlock.setData(byArray);
            vector.add(tBlock);
        }
        return vector;
    }

    public boolean writeFlash(File file, FMovie fMovie, Vector vector, boolean bl) throws Exception {
        try {
            this.bo = new BitOutput(new FileOutputStream(file));
            this.myTypeWriter = new TypeWriter(this.bo, fMovie.getVersion());
        }
        catch (Exception exception) {
            return false;
        }
        if (bl) {
            this.bo.writeByte(67);
            this.bo.writeByte(87);
            this.bo.writeByte(83);
        } else {
            this.bo.writeByte(70);
            this.bo.writeByte(87);
            this.bo.writeByte(83);
        }
        this.bo.ui8(fMovie.getVersion());
        this.bo.ui32(this.determineFlashSize(fMovie, vector));
        if (bl) {
            this.bo.useCompression();
        }
        this.myTypeWriter.rect(fMovie.getRect());
        this.bo.ui16((long)(fMovie.getFrameRate() * 256.0f));
        this.bo.ui16(fMovie.getFrameCount());
        for (int i = 0; i < vector.size(); ++i) {
            TBlock tBlock = (TBlock)vector.get(i);
            this.myTypeWriter.tag(tBlock.getId(), tBlock.getData());
        }
        this.bo.close();
        return true;
    }

    public long determineFlashSize(FMovie fMovie, Vector vector) {
        long l = 3L;
        ++l;
        l += 4L;
        l += this.myTypeWriter._rect(fMovie.getRect());
        l += 2L;
        l += 2L;
        for (int i = 0; i < vector.size(); ++i) {
            TBlock tBlock = (TBlock)vector.get(i);
            l += (long)(tBlock.getData().length + (tBlock.getData().length > 62 ? 6 : 2));
        }
        return l;
    }

    public TBlock readBlock(File file, FMovie fMovie) throws Exception {
        try {
            this.bi = new BitInput(new FileInputStream(file));
            this.bl = new BitLibrary(this.bi);
            this.myTypeReader = new TypeReader(this.bl, this.bi, fMovie.getVersion());
        }
        catch (Exception exception) {
            return null;
        }
        Tag tag = this.myTypeReader.tag();
        TBlock tBlock = new TBlock(tag.id, tag.length);
        byte[] byArray = this.bi.readBytes2((int)tag.length);
        tBlock.setData(byArray);
        this.bi.close();
        return tBlock;
    }

    public boolean writeBlock(File file, FMovie fMovie, TBlock tBlock) throws Exception {
        try {
            this.bo = new BitOutput(new FileOutputStream(file));
            this.myTypeWriter = new TypeWriter(this.bo, fMovie.getVersion());
        }
        catch (Exception exception) {
            return false;
        }
        this.myTypeWriter.tag(tBlock.getId(), tBlock.getData());
        this.bo.close();
        return true;
    }

    public boolean writeData(File file, FMovie fMovie, TBlock tBlock) throws Exception {
        try {
            this.bo = new BitOutput(new FileOutputStream(file));
            this.myTypeWriter = new TypeWriter(this.bo, fMovie.getVersion());
        }
        catch (Exception exception) {
            return false;
        }
        this.bo.writeBytes(tBlock.getData());
        this.bo.close();
        return true;
    }
}

